
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wickerbottom.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/mokey.zip" ),
}
local prefabs = {}

-- Power of Mokey (Working on it)

local fn = function(inst)
	
	-- speech sound and map icon
	inst.soundsname = "mokey"
	inst.MiniMapEntity:SetIcon( "Wilson.png" )

	-- Stats
	inst.components.health:SetMaxHealth(125)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(100)
	inst.components.combat.damagemultiplier = 1.2
 	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 3)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 0.9)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1)
	inst.components.sanity.night_drain_mult = TUNING.WENDY_SANITY_MULT * 5
	inst.components.sanity.neg_aura_mult = 7
end


-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.mokey = "The Mouse"
STRINGS.CHARACTER_NAMES.mokey = "Mokey"
STRINGS.CHARACTER_DESCRIPTIONS.mokey = "* Where is his house?."
STRINGS.CHARACTER_QUOTES.mokey = "\"OOOOH NOOO!!.\""

--Speech
STRINGS.CHARACTERS.MOKEY = {}

STRINGS.CHARACTERS.MOKEY.ACTIONFAIL_GENERIC = "How about no?"
STRINGS.CHARACTERS.MOKEY.ACTIONFAIL_SHAVE = 
	{
		AWAKEBEEFALO = "How about sleep? I need your hair.",
			GENERIC = "shave? ehm no.",
			NOBITS = "There isn't even any stubble left!",
	}
STRINGS.CHARACTERS.MOKEY.ACTIONFAIL_STORE =
	{
			GENERIC = "Damn! full.",
			NOTALLOWED = "Can't go in there.",
	}
	
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_ADVENTUREFAIL = "I need to puke!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_BEES = "Bee careful."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_BOOMERANG = "I need catch it?"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_CHARLIE = "WHO ARE YOU!?"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_CHARLIE_ATTACK = "OOOH NOOO!!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_COLD = "So cold! I need my lovable HOUSE!!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_CRAFTING_FAIL = "Shit! I need more things!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_DEERCLOPS = "Mommy? are you mad?"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_DUSK = "Oh no... I need find my house!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_EAT =
	{
		GENERIC = "YUMMY!!",
		PAINFUL = "What is this? Poop?!",
		SPOILED = "DEAUGH!",
		STALE = "Taste weird.",
	}
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_ENTER_DARK = "I'M BLIND! HELP!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_ENTER_LIGHT = "Oh boy! Mr. Light saved the day"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_FREEDOM = "Free!! now.. where is my house?"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_HIGHRESEARCH = "I am so smart!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_HOUNDS = "HERE COMES THE BITCHES!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_HUNGRY = "OH NO!... I'm so hungry"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_HUNT_BEAST_NEARBY = "So close to Mr. Strange Food man."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_HUNT_LOST_TRAIL = "Shit! I'll find you Mr. Strange Food man."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_INV_FULL = "A lots of stuff!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_KNOCKEDOUT = "Oh no my MIND!!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_LOWRESEARCH = "I never learn."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_MOSQUITOS = "Give me my blood!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_NODANGERSLEEP = "Maybe... not now."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_NODAYSLEEP = "Sleeplessness!."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_NOHUNGERSLEEP = "I'm so hungry!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_NO_TRAP = "Easy for me."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_PECKED = "OUCH!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_QUAKE = "Oh no! The Earth it's Twerking!."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_RESEARCH = "I'm a student all days!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_THORNS = "Ow!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_TORCH_OUT = "OH NO!! MY LIGHT!!"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_TRAP_WENT_OFF = "Oops."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_UNIMPLEMENTED = "Need more time."
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_WORMHOLE = "I am in China?"
STRINGS.CHARACTERS.MOKEY.ANNOUNCE_CANFIX = "\nI think I can fix this!"
STRINGS.CHARACTERS.MOKEY.BATTLECRY =
	{
		GENERIC = "DIE!",
		PIG = "I'm hungry, go die!",
		PREY = "Die for me!",
		SPIDER = "No more Aracnofobia!",
		SPIDER_WARRIOR = "Stop Jumping!",
	}

STRINGS.CHARACTERS.MOKEY.COMBAT_QUIT =
	{
		GENERIC = "I Lost it",
		PIG = "So fast for me...",
		PREY = "Oof... so tired...",
		SPIDER = "Stay away please.",
		SPIDER_WARRIOR = "Jump away!",
		HOUND = "YEAH! BE AFRAID BITCH!!",
	}
STRINGS.CHARACTERS.MOKEY.DESCRIBE =
	{
		EEL = "This will make a delicious meal.",
		EEL_COOKED = "Smells great!",
		UNAGI = "I cooked it myself!",
		EYETURRET = "Eye see you.",
		EYETURRET_ITEM = "I think it's sleeping.",
		MINOTAURHORN = "I got your nose!",
		THULECITE_PIECES = "oranges funny pieces.",
		POND_ALGAE = "Some algae by a pond.",
		GREENSTAFF = "This will come in handy.",
		POTTEDFERN = "I have more in my house.",

		THULECITE = "you are like legos?",
		ARMORRUINS = "It's oddly light.",
		RUINS_BAT = "Are you Dracula?.",
		NIGHTMARE_TIMEPIECE =
		{
		CALM = "Calm like a baby.",
		WARN = "What happened to you?.",
		WAXING = "I want may momma!",
		STEADY = "This is bad!.",
		WANING = "Receding.",
		DAWN = "Almost gone!",
		NOMAGIC = "No magic here.",
		},
		BISHOP_NIGHTMARE = "What Happen with your bulb?",
		ROOK_NIGHTMARE = "Oh no... don't come here please!",
		KNIGHT_NIGHTMARE = "Zombie horse!!",
		MINOTAUR = "Hello Mr big man...you look mad...",
		SPIDER_DROPPER = "Spiders in the ceiling?! no... NOO!!!.",
		NIGHTMARELIGHT = "Scarylight...save the day?",
		GREENGEM = "The green  Rich.",
		RELIC = "The house of my Grandma?",
		RUINS_RUBBLE = "This can be fixed.",
		MULTITOOL_AXE_PICKAXE = "and it have a cupholder.",
		ORANGESTAFF = "I'll Disappear.",
		YELLOWAMULET = "IronMouse!.",
		GREENAMULET = "I couldn't get any better.",
		SLURPERPELT = "I have your fluffy body.",	

		SLURPER = "A living Plush!",
		SLURPER_PELT = "I have your fluffy body.",
		ARMORSLURPER = "Deaugh with this suit.",
		ORANGEAMULET = "Come to papah!.",
		YELLOWSTAFF = "I'm god with my light creator!",
		YELLOWGEM = "Yellow Rich.",
		ORANGEGEM = "It isn't annoying and it's a gem.",
		TELEBASE = 
		{
			VALID = "It's ready to go.",
			GEMS = "It needs more purple gems.",
		},
		GEMSOCKET = 
		{
			VALID = "Looks ready.",
			GEMS = "It needs a gem.",
		},
		STAFFLIGHT = "That seems really dangerous.",
		RESEARCHLAB4 = "Who would name something that?",
	
        ANCIENT_ALTAR = "An ancient and mysterious structure.",

        ANCIENT_ALTAR_BROKEN = "This seems to be broken.",

        ANCIENT_STATUE = "It seems to throb out of tune with the world.",

        LICHEN = "Only a cyanobacteria could grow in this light.",
		CUTLICHEN = "Nutritious, but it won't last long.",

		CAVE_BANANA = "Banana!",
		CAVE_BANANA_COOKED = "Yum Yummy!",
		CAVE_BANANA_TREE = "Oh boy! I love bananas!.",
		ROCKY = "Are you a pokemon?",
		
		COMPASS =
		{
			GENERIC="I can't get a reading.",
			N = "North",
			S = "North",
			E = "North",
			W = "North",
			NE = "North",
			SE = "North",
			NW = "North",
			SW = "North",
		},

		NIGHTMARE_TIMEPIECE =
		{
			CALM = "Calm like a baby.",
			WARN = "What happened to you?.",
			WAXING = "I want may momma!",
			STEADY = "This is bad!.",
			WANING = "Receding.",
			DAWN = "Almost gone!",
			NOMAGIC = "No magic here.",
		},

		HOUNDSTOOTH= "Tooth Fairy? Where are you?",
		ARMORSNURTLESHELL= "Nice protection!",
		BAT= "Are you Dracula?",
		BATBAT = "I'm Batman?",
		BATWING= "I can fly with this?",
		BATWING_COOKED= "A boomerang?",
		BEDROLL_FURRY= "So comfortable!",
		BUNNYMAN= "What time is it?",
		FLOWER_CAVE= "1! 1 flower!",
		FLOWER_CAVE_DOUBLE= "2! 2 flowers.",
		FLOWER_CAVE_TRIPLE= "3! 3 flowers!.",
		GUANO= "White piece of shit.",
		LANTERN= "I got you Mr. Light.",
		LIGHTBULB="Can I eat the light?.",
		MANRABBIT_TAIL= "A fluffy but.",
		MUSHTREE_TALL  = "Tree with blue light?!",
		MUSHTREE_MEDIUM= "Tree with red light?!",
		MUSHTREE_SMALL = "Tree with green light?!",
		RABBITHOUSE="I can eat your HOUSE?.",
		SLURTLE="You are so EW!",
		SLURTLE_SHELLPIECES="YAY!a puzzle.",
		SLURTLEHAT="I am a shark!!",
		SLURTLEHOLE="Why your house have spikes?.",
		SLURTLESLIME="Explosive shit!",
		SNURTLE="are you running?",
		SPIDER_HIDER="A spider with protection hat? still scares me",
		SPIDER_SPITTER="Spit? that's nasty!",
		SPIDERHOLE="More creepy than normal spider HOUSE!",
		STALAGMITE="This is a stala... an other rock.",
		STALAGMITE_FULL="This is a stala... an other rock.",
		STALAGMITE_LOW="One more!",
		STALAGMITE_MED="So close.",
		STALAGMITE_TALL="This is a stala... an other rock.",
		STALAGMITE_TALL_FULL="This is a stala... an other rock.",
		STALAGMITE_TALL_LOW="One more!",
		STALAGMITE_TALL_MED="So close.",
		TURF_FUNGUS="A pieces of the earth.",
		TURF_MUD="A pieces of the earth.",
		TURF_SINKHOLE="A pieces of the earth.",
		TURF_UNDERROCK="A pieces of the earth.",	

		POWCAKE = "POW OF PUKE!",
        CAVE_ENTRANCE = 
        {
            GENERIC="Hmm a strange stone.",
            OPEN = "It's so dark down there.",
        },
        CAVE_EXIT = "I'm back!",
		MAXWELLPHONOGRAPH = "I love Music!",
		BOOMERANG = "A Backmerang!",
		PIGGUARD = "What is your problem?",
		ABIGAIL = "OH NO!!! A GIRL GHOST!!! WHERE IS THE HAIR?!",
		ADVENTURE_PORTAL = "LET'S GO TO FIND MY HOUSE!",
		AMULET = "I'm invincible",
		ANIMAL_TRACK = "Mr. Food!.",
		ARMORGRASS = "Grass for they can't beat my ass!",
		ARMORMARBLE = "So heavy for me.",
		ARMORWOOD = "Woodman!",
		ARMOR_SANITY = "This armour is... strange...i don't like that feel",
		ASH =
		{
			GENERIC = "This remember me one of my brothers.",
			REMAINS_EYE_BONE = "Eye don't have any idea what happen!",
			REMAINS_THINGIE = "This was once some thing...",
		},
		AXE = "Wood killer!",
		BABYBEEFALO = "A Lovable machine of shit!",
		BACKPACK = "Let's go to the school!",
		BACONEGGS = "My Breakfast.",
		BANDAGE = "Looks sweet.",
		BASALT = "Father of rocks",
		BATBAT = "I'm BAHMAN!.",
		BEARDHAIR = "Well... you aren't in my walls.",
		BEDROLL_STRAW = "Sleepy sleep bed!",
		BEE =
		{
			GENERIC = "Bee careful.",
			HELD = "Careful!",
		},
		BEEBOX =
		{
			FULLHONEY = "It's full of honey.",
			GENERIC = "I'm the Queen bee",
			NOHONEY = "Where is my honey?.",
			SOMEHONEY = "I need more honey.",
		},
		BEEFALO =
		{
			FOLLOWER = "What you want?! stop follow me!",
			GENERIC = "OH LOOK! a Foodfalo!",
			NAKED = "You need a towel?",
			SLEEPING = "Sleep and give me your hair.",
		},
		BEEFALOHAT = "Now I'm a Foodalo... wait...",
		BEEFALOWOOL = "smells like... yes.",
		BEEHAT = "Now put your buts in my face! I have protection!.",
		BEEHIVE = "You can give me some honey, please?",
		BEEMINE = "Wait my little mad bees",
		BEEMINE_MAXWELL = "Bottled mosquito rage!",
		BERRIES = "I love berries!",
		BERRIES_COOKED = "Oh Boy!.",
		BERRYBUSH =
		{
			BARREN = "Hmmm... you need shit!",
			GENERIC = "I love berries!.",
			PICKED = "I want more berries!",
		},
		BIRDCAGE =
		{
			GENERIC = "This cage need something...",
			OCCUPIED = "Now I'm your boss!",
			SLEEPING = "Awwww, he's asleep.",
		},
		BIRDTRAP = "Land here!",
		BIRD_EGG = "Bird testicles.",
		BIRD_EGG_COOKED = "Cooked testicles! yummy!",
		BISHOP = "A Bulb with an eye!",
		BLOWDART_FIRE = "I BLOW THE FIRE!!",
		BLOWDART_SLEEP = "Sleep! you need it!",
		BLUEAMULET = "Cool, calm... oh my god i love this!",
		BLUEGEM = "Blue Money!.",
		BLUEPRINT = "A blue paper with cool draws!",
		BLUE_CAP = "Blue toxic food.",
		BLUE_CAP_COOKED = "Now is blue toxic cooked food.",
		BLUE_MUSHROOM =
		{
			GENERIC = "Why in the night!?",
			INGROUND = "You are red, green or blue?",
			PICKED = "Come back blue guy!",
		},
		BOARDS = "Some wheels and i'll have a skateboard.",
		BOAT = "I can escape!",
		BONESTEW = "I cooked it myself!",
		BUGNET = "Here i Come you bug bastards!",
		BUSHHAT = "Oh Boy! My hat is so... hatty",
		BUTTER = "How about fly... my butter!?",
		BUTTERFLY =
		{
			GENERIC = "You are so beauty for my stomach",
			HELD = "I don't feel you in my stomach",
		},
		BUTTERFLYMUFFIN = "You are a Muffinfly!",
		BUTTERFLYWINGS = "Beauty food wings!.",
		CAMPFIRE =
		{
			EMBERS = "Hi little fire!.",
			GENERIC = "Light for me",
			HIGH = "So warm, so good",
			LOW = "Oh no... OH NO!.",
			NORMAL = "Nice fire.",
			OUT = "Where are you Mr. fire?",
		},
		CANE = "SO FAST!",
		CARROT = "I want a car... but a rot?",
		CARROT_COOKED = "Smell good",
		CARROT_PLANTED = "give me a tree of cars and rots!",
		CARROT_SEEDS = "Car seed rot.",
		CAVE_FERN = "Yeah more plants!",
		CHARCOAL = "I hate you Santa!",
        CHESSJUNK1 = "A Pile of broken pieces.",
        CHESSJUNK2 = "More pile of broken pieces?.",
        CHESSJUNK3 = "This chess is a mess!",
		CHESTER = "Hello little friend!!.",
		CHESTER_EYEBONE =
		{
			GENERIC = "I have your eye?! oh...",
			WAITING = "...Why?...",
		},
		COOKEDMANDRAKE = "Are you sleeping?",
		COOKEDMEAT = "Steak time.",
		COOKEDMONSTERMEAT = "I don't know... I don't want this meat.",
		COOKEDSMALLMEAT = "This is not enough for my stomach!",
		COOKPOT =
		{
			COOKING_LONG = "I'M SO HUNGRY!! QUICKLY!!!.",
			COOKING_SHORT = "Now? no... ok.",
			DONE = "OH BOY!",
			EMPTY = "I need to cook something.",
		},
		CORN = "I LOVE CORN! Is my favourite band.",
		CORN_COOKED = "Movie time!!",
		CORN_SEEDS = "It's a seed.",
		CROW =
		{
			GENERIC = "I don't like that poem",
			HELD = "My poem is my stomach.",
		},
		CUTGRASS = "Grassy Grass for my ass.",
		CUTREEDS = "The arms of the Life!.",
		CUTSTONE = "Hm, nice shape.",
		DEERCLOPS = "OOOHH NOOO A BIG BAD EYE MONSTER!!!!",
		DEERCLOPS_EYEBALL = "Stop watching me",
		DEPLETED_GRASS =
		{
			GENERIC = "Tuft of grassy grass.",
		},
		DEVTOOL = "Smells good, like bacon",
		DEVTOOL_NODEV = "I'm not strong enough to wield it.",
		DIRTPILE = "It's a pile of dirt",
		DIVININGROD =
		{
			COLD = "Nothing here.",
			GENERIC = "I know you some where...",
			HOT = "This way!",
			WARM = "Almost.",
			WARMER = "IT'S NEAR!.",
		},
		DIVININGRODBASE =
		{
			GENERIC = "What are you Mr?.",
			READY = "You needs a large key.",
			UNLOCKED = "Now my machine can work!",
		},
		DIVININGRODSTART = "That rod looks useful!",
		DRAGONFRUIT = "Where is my fire you fruity dragon!.",
		DRAGONFRUIT_COOKED = "That's why i love dragons.",
		DRAGONFRUIT_SEEDS = "It's a seed.",
		DRAGONPIE = "I love pies!",
		DRUMSTICK = "I should gobble it.",
		DRUMSTICK_COOKED = "Now it's tastier.",
		DUG_BERRYBUSH = "I should plant this for my berry farm.",
		DUG_GRASS = "I should plant this.",
		DUG_MARSH_BUSH = "I should plant this.",
		DUG_SAPLING = "I should plant this.",
		DURIAN = "Smelly Durian!",
		DURIAN_COOKED = "Smelly... oh my god i don't want it",
		DURIAN_SEEDS = "It's a seed.",
		EARMUFFSHAT = "Warm for my ears...wait...",
		EGGPLANT = "Where is my egg?.",
		EGGPLANT_COOKED = "This is my favorite egg.",
		EGGPLANT_SEEDS = "It's a seed.",
		EVERGREEN =
		{
			BURNING = "This is so bad....",
			BURNT = "OH MY BOY! a black tree.",
			CHOPPED = "TREE KILLER!",
			GENERIC = "You remind me a creepy man with suit.",
		},
		EVERGREEN_SPARSE =
		{
			BURNING = "This is so bad...",
			BURNT = "OH MY GOD!.",
			CHOPPED = "TREE KILLER!",
			GENERIC = "Creepy Tree... Still remind me that creepy man.",
		},
		EYEPLANT = "Stop watching me!",
		FARMPLOT =
		{
			GENERIC = "It's a nice day for plant.",
			GROWING = "Grow like your papa tree",
			NEEDSFERTILIZER = "It wants some Poopy shit.",
		},
		FEATHERHAT = "Now i am the king of HAO!",
		FEATHER_CROW = "Poem feather.",
		FEATHER_ROBIN = "phoenix feather.",
		FEATHER_ROBIN_WINTER = "Ice feather.",
		FEM_PUPPET = "She's trapped!",
		FIREFLIES =
		{
			GENERIC = "Why that bugs have Mr light?!",
			HELD = "Yes.. light in my hand!",
		},
		FIREHOUND = "You are a hot BITCH!",
		FIREPIT =
		{
			EMBERS = "Hi little fire!.",
			GENERIC = "Light for me",
			HIGH = "So warm, so good",
			LOW = "Oh no... OH NO!.",
			NORMAL = "Nice fire.",
			OUT = "Where are you Mr. fire?",
		},
		FIRESTAFF = "I'm a magic mouse!",
		FISH = "Well, you aren't a shark.",
		FISHINGROD = "Time for fishing!",
		FISHSTICKS = "YUMMY!",
		FISHTACOS = "Fishy TACOS!!",
		FISH_COOKED = "little food? but the fish was big!",
		FLINT = "I have a rock!.",
		FLOWER = "OH BOY! a lovable flower.",
		FLOWERHAT = "I'm nature guy.",
		FLOWER_EVIL = "BAD FLOWER!",
		FOLIAGE = "leafy greens.",
		FOOTBALLHAT = "protection for head!.",
		FROG =
		{
			DEAD = "Shut your mouth.",
			GENERIC = "Croak to you!",
			SLEEPING = "Are you sleeping?",
		},
		FROGGLEBUNWICH = "I cooked it myself!",
		FROGLEGS = "Legs go to cook this lets!.",
		FROGLEGS_COOKED = "Nice delicious frog leg.",
		FRUITMEDLEY = "MEDLEY?! CAN I HEAR IT?!",
		GEARS = "metal!",
		GHOST = "Is Halloween?",
		GOLDENAXE = "Tree Killer for rich people.",
		GOLDENPICKAXE = "Pick my rich!",
		GOLDENPITCHFORK = "golden...what?",
		GOLDENSHOVEL = "I can't wait to dig holes.",
		GOLDNUGGET = "Gold!!! I'm so rich!!",
		GRASS =
		{
			BARREN = "You need poop?",
			BURNING = "NOOO MY GRASS!!",
			GENERIC = "Grassy Grass for my ass.",
			PICKED = "It will grow back.",
		},
		GREEN_CAP = "Green toxic food.",
		GREEN_CAP_COOKED = "Now is green toxic cooked food.",
		GREEN_MUSHROOM =
		{
			GENERIC = "Why in the dusk?.",
			INGROUND = "You are red, green or blue?",
			PICKED = "Come back green guy!",
		},
		GUNPOWDER = "BOOM! BITCH!",
		HAMBAT = "I'll punch you with my food!",
		HAMMER = "Let's smash something!",
		HEALINGSALVE = "This can make me feel better.",
		HEATROCK =
		{
			COLD = "Is this ice or a rock?!",
			GENERIC = "at least it's not so cold.",
			HOT = "Hot! i like it!",
			WARM = "Can I touch it?",
		},
		HOME = "Look! my new HOUSE!!.",
		HOMESIGN = "It says ... wait... is empty.",
		HONEY = "Yummy!",
		HONEYCOMB = "New home for you, bees.",
		HONEYHAM = "I WANT MORE OF THIS!",
		HONEYNUGGETS = "AHHHH HEAVEN!",
		HORN = "Nice horn... for me. ",
		HOUND = "STAY AWAY BITCH!",
		HOUNDBONE = "The bone of the bitch",
		HOUNDMOUND = "Where the bitches live!",
		ICEBOX = "My kitchen is complete",
		ICEHOUND = "You are a cold bitch.. STAY AWAY!",
		INSANITYROCK =
		{
			ACTIVE = "What the...but...how?",
			INACTIVE = "Tiny pyramid.",
		},
		JAMMYPRESERVES = "I cooked it myself!",
		KABOBS = "Nom nom nom",
		KILLERBEE =
		{
			GENERIC = "BAD BEE!",
			HELD = "This seems dangerous.",
		},
		KNIGHT = "oh my gah, a little pony!",
		KOALEFANT_SUMMER = "Come here... i don't want eat you",
		KOALEFANT_WINTER = "Come here... i don't want eat you.",
		KRAMPUS = "OOOH NOOO!!! SATAN'S FRIEND!! GO AWAY IN THE NAME OF CHRIST!",
		KRAMPUS_SACK = "Where is the gifts?.",
		LEIF = "He's huge!",
		LEIF_SPARSE = "He's huge!",
		LIGHTNING_ROD =
		{
			CHARGED = "Light for me!",
			GENERIC = "I can harness the heavens!",
		},
		LITTLE_WALRUS = "I hate your father and your dogs!",
		LIVINGLOG = "Creepy log.",
		LOCKEDWES = "Are you living in a box?",
		LOG =
		{
			BURNING = "Aw! They having sex.",
			GENERIC = "Say hello to your friend... the fire!",
		},
		LUREPLANT = "Eat much, eh?.",
		LUREPLANTBULB = "Come here my hungry friend.",
		MALE_PUPPET = "He's trapped!",
		MANDRAKE =
		{
			DEAD = "Thanks for shut your mouth!",
			GENERIC = "Shut up!",
			PICKED = "Stop following me!",
		},
		MANDRAKESOUP = "Eat and scream.",
		MANDRAKE_COOKED = "Eat and scream.",
		MARBLE = "Fancy!",
		MARBLEPILLAR = "Looks expensive.",
		MARBLETREE = "Marble tree? it's expensive?.",
		MARSH_BUSH =
		{
			BURNING = "Yeah! burning you spike bush!",
			GENERIC = "It looks Spiky.",
			PICKED = "OUCH!.",
		},
		MARSH_PLANT = "It's a plant.",
		MARSH_TREE =
		{
			BURNING = "Spikes in fire!",
			BURNT = "Now it's burnt and spiky.",
			CHOPPED = "Not so spiky now!",
			GENERIC = "You know something... slender?",
		},
		MAXWELL = "Who are you? WHERE IS MY HOUSE!?",
		MAXWELLHEAD = "GIVE ME MY HOUSE!.",
		MAXWELLLIGHT = "Magic light.",
		MAXWELLLOCK = "Looks almost like a key hole.",
		MAXWELLTHRONE = "Poor guy... Where is my house?",
		MEAT = "MEAT!.",
		MEATBALLS = "Meat my balls!!",
		MEATRACK =
		{
			DONE = "Time to eat!",
			DRYING = "it's done?.",
			GENERIC = "Time to dry some meat.",
		},
		MEAT_DRIED = "Jerky enough.",
		MERM = "Fishman?",
		MERMHEAD = "Oh no... my hero Fishman.",
		MERMHOUSE = "Creepy house!",
		MINERHAT = "I have the light in my head!.",
		MONKEY = "Where is your tie?.",
		MONKEYBARREL = "You live in a barrel?",
		MONSTERLASAGNA = "I don't trust this lasagna",
		MONSTERMEAT = "I don't want eat that.",
		MONSTERMEAT_DRIED = "Strange-smelling jerky.",
		MOSQUITO =
		{
			GENERIC = "Give me my blood!.",
			HELD = "Now i'll take what is mine",
		},
		MOUND =
		{
			DUG = "I should probably feel bad about that.",
			GENERIC = "I bet there's all sorts of good stuff down there!",
		},
		NIGHTLIGHT = "Dark and evil light.",
		NIGHTMAREFUEL = "Nightmare fuel? i need a nightmare car.",
		NIGHTSWORD = "The power of the darkness.. in my hands.",
		NITRE = "yellow rock?",
		ONEMANBAND = "One MOUSE band!",
		PANDORASCHEST = "I remember you... you know something about explore? ",
		PANFLUTE = "Sleep my beauty things.",
		PAPYRUS = "Papyrus? I call it ... paper",
		PENGUIN = "Nice Suit.",
		PERD = "Stupid turkey! Stop eating my berries!",
		PEROGIES = "I cooked it myself!",
		PETALS = "One for my girlfriend Mommy!",
		PETALS_EVIL = "For Mommy?... ehm... no.",
		PICKAXE = "Now I can break some rock",
		PIGGYBACK = "Too heavy but i love my piggyback.",
		PIGHEAD = "I feel bad for this pig.",
		PIGHOUSE =
		{
			FULL = "Hello Mr. Piggy, it's me, Mokey MOUSE!",
			GENERIC = "Hey Look! a Pig HOUSE!!",
			LIGHTSOUT = "Can i sleep with you?",
		},
		PIGKING = "ALL HEIL THE PIG!",
		PIGMAN =
		{
			DEAD = "Foodman!",
			FOLLOWER = "Mr. Piggy friend!",
			GENERIC = "Oh you're a big pig food.",
			GUARD = "What is your problem?",
			WEREPIG = "OH NO! Mr. Pig is a Wolf and it's bad!",
		},
		PIGSKIN = "Pig butt... but pig.",
		PIGTENT = "Smells like bacon.",
		PIGTORCH = "The torch of piggydoom.",
		PINECONE = 
		{
		    GENERIC = "I can feel life in here.",
		    PLANTED = "keep growing.",
		},
		PITCHFORK = "Fork the ground.",
		PLANTMEAT = "This is meat or plant? It's food anyway.",
		PLANTMEAT_COOKED = "Plant cooked.",
		PLANT_NORMAL =
		{
			GENERIC = "First Step of life.",
			GROWING = "Grow faster.",
			READY = "Time to eat.",
		},
		POMEGRANATE = "alien's brain?",
		POMEGRANATE_COOKED = "Yummy!",
		POMEGRANATE_SEEDS = "It's a seed.",
		POND = "I smell food in there.",
		POOP = "Oh boy! some shitty poop!",
		PUMPKIN = "This is... halloween?",
		PUMPKINCOOKIE = "Halloween cookies!",
		PUMPKIN_COOKED = "Cooked halloween!.",
		PUMPKIN_LANTERN = "Happy Halloween to you",
		PUMPKIN_SEEDS = "It's a seed.",
		PURPLEAMULET = "It's whispering to me.",
		PURPLEGEM = "Purple, the color of my future!",
		RABBIT =
		{
			GENERIC = "Cute little food.",
			HELD = "Cute food in my hands!",
		},
		RABBITHOLE = "I wonder how is it inside.",
		RAINOMETER = "The time is...",
		RATATOUILLE = "My favorite movie... i mean food.",
		RAZOR = "I wanna shape something!",
		REDGEM = "Red bloddy rich!",
		RED_CAP = "Red toxic food.",
		RED_CAP_COOKED = "Now is red toxic cooked food.",
		RED_MUSHROOM =
		{
			GENERIC = "Good morning Mr. mush!.",
			INGROUND = "You are red, green or blue?",
			PICKED = "Come back red guy!",
		},
		REEDS =
		{
			BURNING = "That's really burning!",
			GENERIC = "Nice Reeds man!",
			PICKED = "I picked all the useful reeds.",
		},
        RELIC = 
        {
            GENERIC = "Grandma? are you living here? ",
            BROKEN = "Someone broke the things of my grandma.",
        },
        RUINS_RUBBLE = "This can be fixed.",
        RUBBLE = "Pieces of rock.",
		RESEARCHLAB = "Time to create something.",
		RESEARCHLAB2 = "I got a headache now",
		RESEARCHLAB3 = "I create the darkness!",
		RESEARCHLAB4 = "So... you're a stone with magical knowledge?",
		RESURRECTIONSTATUE = "Statue of Devil",
		RESURRECTIONSTONE = "What an odd looking stone.",
		ROBIN =
		{
			GENERIC = "Is that a phoenix?",
			HELD = "Don't burn my pocket.",
		},
		ROBIN_WINTER =
		{
			GENERIC = "Oh! a Ic bird!.",
			HELD = "Don't melt you in my pocket.",
		},
		ROBOT_PUPPET = "Oh boy! a toy!",
		ROCK_LIGHT =
		{
			GENERIC = "A crusted over lava pit.",
			OUT = "Looks fragile.",
			LOW = "The lava's crusting over.",
			NORMAL = "Nice and comfy.",
		},
		ROCK = "Rocky Rock in the world.",
		ROCKS = "Rock for me!",
        ROOK = "Storm the castle!",
		ROPE = "I Rope this hope should be usefull.",
		ROTTENEGG = "Ewwwww!",
		SANITYROCK =
		{
			ACTIVE = "Mr. Big black rock!",
			INACTIVE = "Wait... but you're bigger the last time.",
		},
		SAPLING =
		{
			BURNING = "NOOO!!",
			GENERIC = "Baby trees!",
			PICKED = "That'll teach him.",
		},
		SEEDS = "So, The birds loves you?.",
		SEEDS_COOKED = "I'm so hungry, sorry",
		SEWING_KIT = "I'm bad at this but whatever.",
		SHOVEL = "Dig Dig Dig!",
		SILK = "I hate this... but you don't have spiders so it's fine.",
		SKELETON = "RIP my friend.",
		SKULLCHEST = "...friend?",
		SMALLBIRD =
		{
			GENERIC = "You are a beautiful food!.",
			HUNGRY = "You need some food?",
			STARVING = "I'm hungry to.",
		},
		SMALLMEAT = "To small for me.",
		SMALLMEAT_DRIED = "Small but good taste.",
		SPEAR = "Let's fight!",
		SPIDER =
		{
			DEAD = "Aracnofobia? not any more!",
			GENERIC = "AAAAAAH I HAVE ARACNOFOBIA!!",
			SLEEPING = "It's my time... still scares me",
		},
		SPIDERDEN = "So scary for my pants.",
		SPIDEREGGSACK = "I'll burn you!",
		SPIDERGLAND = "This is not scary.",
		SPIDERHAT = "I DON'T WANT THIS IN MY HEAD!",
		SPIDERQUEEN = "AHHHHHHHH! NOOO! YOU! NOOO! MY PANTS!",
		SPIDER_WARRIOR =
		{
			DEAD = "Why you can jump!?!",
			GENERIC = "Help me... that thing... can jump...",
			SLEEPING = "It's my time...",
		},
		SPOILED_FOOD = "I won't eat that.",
		STATUEHARP = "Too bad, you don't have head for think about it.",
		STATUEMAXWELL = "Who's this guy?",
		STINGER = "From bee's butt!",
		STRAWHAT = "I don't like wearing this much...",
		STUFFEDEGGPLANT = "Mmm... This must be really tasty.",
		SUNKBOAT = "What happen to it..",
		TAFFY = "I cooked it myself!",
		TALLBIRD = "OH NO! YOU EYE BIRD MONSTER!",
		TALLBIRDEGG = "WThat egg looks dilicious!",
		TALLBIRDEGG_COOKED = "Delicious and nutritional.",
		TALLBIRDEGG_CRACKED =
		{
			COLD = "It needs warm.",
			GENERIC = "Ohhh hatching!",
			HOT = "I am not cooking eggs.",
			LONG = "I have a feeling this is going to take a while...",
			SHORT = "It should hatch any time now.",
		},
		TALLBIRDNEST =
		{
			GENERIC = "You have food!",
			PICKED = "The nest is empty.",
		},
		TEENBIRD =
		{
			GENERIC = "How come you turn ugly...",
			HUNGRY = "I'm hungry to man!",
			STARVING = "Ok Ok!! I'll give you some food.",
		},
		TELEBASE =
		{
			VALID = "It's ready to magic.",
			GEMS = "It needs purple gems.",
		},
		GEMSOCKET = 
		{
			VALID = "Looks ready.",
			GEMS = "It needs a gem.",
		},
		TELEPORTATO_BASE =
		{
			ACTIVE = "LET'S GO TO FIND MY HOUSE!!",
			GENERIC = "Is this a portal?",
			LOCKED = "I neew something",
			PARTIAL = "So close to find MY HOUSE.",
		},
		TELEPORTATO_BOX = "Is a box...the end.",
		TELEPORTATO_CRANK = "What's this for?",
		TELEPORTATO_POTATO = "Ouch! my teeth",
		TELEPORTATO_RING = "Yellow circle!.",
		TELESTAFF = "Should I use this?",
		TENT = "I can have a good sleep with this.",
		TENTACLE = "There is a octopus down?",
		TENTACLESPIKE = "It's pointy and slimy.",
		TENTACLESPOTS = "I shouldn't go near that.",
		TENTACLE_PILLAR = "This is not good...",
		TENTACLE_PILLAR_ARM = "Whoa, too many!",
		TENTACLE_GARDEN = "Yet another slimy pole.",
		TOPHAT = "Hahaha This sounds like magic.",
		TORCH = "Little light for life.",
		TRAP = "Come here little food.",
		TRAP_TEETH = "This is a nasty surprise.",
		TRAP_TEETH_MAXWELL = "That's not my trap!",
		TREASURECHEST = "Is this a treasure?",
		TREASURECHEST_TRAP = "How convenient!",
		TREECLUMP = "It's almost like someone is trying to prevent me from going somewhere.",
		TRINKET_1 = "They are all melted together.",
		TRINKET_10 = "I hope I get out of here before I need these.",
		TRINKET_11 = "He whispers beautiful lies to me.",
		TRINKET_12 = "I'm not sure what I should do with a dessicated tentacle.",
		TRINKET_2 = "It's just a cheap replica.",
		TRINKET_3 = "The knot is stuck. Forever.",
		TRINKET_4 = "It must be some kind of religious artifact.",
		TRINKET_5 = "Sadly, it's too small for me to escape on.",
		TRINKET_6 = "Their electricity carrying days are over.",
		TRINKET_7 = "I have no time for fun and games!",
		TRINKET_8 = "Great. All of my tub stopping needs are met.",
		TRINKET_9 = "I'm more of a zipper person, myself.",
		TRUNKVEST_SUMMER = "I knew it, I should eat the trunk.",
		TRUNKVEST_WINTER = "It's warm but I seriously should eat the trunk.",
		TRUNK_COOKED = "THE BESET STEAK EVER!.",
		TRUNK_SUMMER = "A light breezy trunk.",
		TRUNK_WINTER = "A thick, hairy trunk.",
		TURF_CARPETFLOOR = "Like my lovable house.",
		TURF_CHECKERFLOOR = "Pretty floor.",
		TURF_DIRT = "A chunk of ground.",
		TURF_FOREST = "A chunk of ground.",
		TURF_GRASS = "A chunk of ground.",
		TURF_MARSH = "A chunk of ground.",
		TURF_ROAD = "Hastily cobbled stones.",
		TURF_ROCKY = "A chunk of ground.",
		TURF_SAVANNA = "A chunk of ground.",
		TURF_WOODFLOOR = "These are floorboards.",
		TURKEYDINNER = "Mmmm.",
		TWIGS = "Arms of nature.",
		UMBRELLA = "Umbrella ella ella e e e e.",
		UNIMPLEMENTED = "I need to finish it.",
		WAFFLES = "I cooked it myself!",
		WALL_HAY = "Hmmmm. I guess that'll have to do.",
		WALL_HAY_ITEM = "This seems like a bad idea.",
		WALL_STONE = "That's a nice wall.",
		WALL_STONE_ITEM = "They make me feel so safe.",
		WALL_RUINS = "An ancient piece of wall.",
		WALL_RUINS_ITEM = "A solid piece of history.",
		WALL_WOOD = "Pointy!",
		WALL_WOOD_ITEM = "Pickets!",
		WALRUS = "I hate you Mr. Daddy!",
		WALRUSHAT = "The Best hat!.",
		WALRUS_CAMP =
		{
			EMPTY = "Somebody was camping here.",
			GENERIC = "Hello? Your know where is my HOUSE!?",
		},
		WALRUS_TUSK = "The tooth of Mr. Daddy.",
		WASPHIVE = "I hate that bees.",
		WETGOOP = "I cooked it myself!",
		WINTERHAT = "Warm for my head.",
		WINTEROMETER = "What is that? what is C?.",
		WORMHOLE =
		{
			GENERIC = "What is that?.",
			OPEN = "Is a monster or a hole?",
		},
		WORMHOLE_LIMITED = "You look sick Mr. Monster Hole man.",
		GENERIC = "It's a... thing.",
		TOODARK = "It's too dark.",
		EAT_FOOD =
		{
		TALLBIRDEGG_CRACKED = "Mmm. Beaky.",
		}
	}

return MakePlayerCharacter("mokey", prefabs, assets, fn)
